/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.web.resources.ShortParam;

public class PermissionParam
extends ShortParam {
    public static final String NAME = "permission";
    public static final String DEFAULT = "null";
    private static final ShortParam.Domain DOMAIN = new ShortParam.Domain("permission", 8);
    private static final short DEFAULT_DIR_PERMISSION = 493;
    private static final short DEFAULT_FILE_PERMISSION = 420;
    private static final short DEFAULT_SYMLINK_PERMISSION = 511;

    public static FsPermission getDefaultDirFsPermission() {
        return new FsPermission(493);
    }

    public static FsPermission getDefaultFileFsPermission() {
        return new FsPermission(420);
    }

    public static FsPermission getDefaultSymLinkFsPermission() {
        return new FsPermission(511);
    }

    public PermissionParam(FsPermission value) {
        this(DOMAIN, value == null ? null : Short.valueOf(value.toShort()), null, null);
    }

    public PermissionParam(String str) {
        this(DOMAIN, DOMAIN.parse(str), (short)0, (short)1023);
    }

    PermissionParam(ShortParam.Domain domain, Short value, Short min2, Short max) {
        super(domain, value, min2, max);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public FsPermission getFileFsPermission() {
        return this.getFsPermission((short)420);
    }

    public FsPermission getDirFsPermission() {
        return this.getFsPermission((short)493);
    }

    private FsPermission getFsPermission(short defaultPermission) {
        Short v = (Short)this.getValue();
        return new FsPermission(v != null ? v : defaultPermission);
    }
}

