/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.nodelabels.AbstractLabel;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMNodeLabel
extends AbstractLabel
implements Comparable<RMNodeLabel> {
    private boolean exclusive;
    private NodeLabel nodeLabel;
    private Set<NodeId> nodeIds;

    public RMNodeLabel(NodeLabel nodeLabel) {
        this(nodeLabel.getName(), Resource.newInstance(0, 0), 0, nodeLabel.isExclusive());
    }

    public RMNodeLabel(String labelName) {
        this(labelName, Resource.newInstance(0, 0), 0, true);
    }

    protected RMNodeLabel(String labelName, Resource res, int activeNMs, boolean exclusive) {
        super(labelName, res, activeNMs);
        this.exclusive = exclusive;
        this.nodeLabel = NodeLabel.newInstance(labelName, exclusive);
        this.nodeIds = new HashSet<NodeId>();
    }

    public void setIsExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean getIsExclusive() {
        return this.exclusive;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RMNodeLabel) {
            RMNodeLabel other = (RMNodeLabel)obj;
            return Resources.equals(this.getResource(), other.getResource()) && StringUtils.equals(this.getLabelName(), other.getLabelName()) && other.getNumActiveNMs() == this.getNumActiveNMs();
        }
        return false;
    }

    public RMNodeLabel getCopy() {
        return new RMNodeLabel(this.getLabelName(), this.getResource(), this.getNumActiveNMs(), this.exclusive);
    }

    public int hashCode() {
        int prime = 502357;
        return (int)((((long)this.getLabelName().hashCode() << 8) + (long)(this.getResource().hashCode() << 4) + (long)this.getNumActiveNMs()) % 502357L);
    }

    @Override
    public int compareTo(RMNodeLabel o) {
        if (this.getLabelName().isEmpty() != o.getLabelName().isEmpty()) {
            if (this.getLabelName().isEmpty()) {
                return -1;
            }
            return 1;
        }
        return this.getLabelName().compareTo(o.getLabelName());
    }

    public NodeLabel getNodeLabel() {
        return this.nodeLabel;
    }

    public void addNodeId(NodeId node) {
        this.nodeIds.add(node);
    }

    public void removeNodeId(NodeId node) {
        this.nodeIds.remove(node);
    }

    public Set<NodeId> getAssociatedNodeIds() {
        return new HashSet<NodeId>(this.nodeIds);
    }
}

