package jacob;

import jacob.tool.JacobInterface;

/**
 * Every editor is free to ignore whatever it likes.
 *
 * @see EditorAdapter
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: EditorInterface.java,v 1.4 1999/02/22 11:44:02 clemens Exp clemens $
 */
public interface EditorInterface {
    /**
     * Well, the editor sometimes needs access to the package
     * tree to locate paths etc.
     */
    public void init(JacobInterface pJacobInterface_);
    
    /**
     * This method should maybe wait until the file is loaded
     * into the editor. Don't know if it hurts otherwise, at
     * least that's the way I do it with Emacs.
     */
    public void editFile(String sFileFullName_);

    /**
     * Inserts a string at the current cursor position.
     * Cursor is afterwords behind inserted string.
     */
    public void insertString( String pString_ );

    /**
     * Line counting starts with 1, not 0.
     */
    public void gotoLine( int line_ );
    
    /**
     * Column counting starts with 1, not 0.
     */
    public void gotoColumn( int column_ );

    /**
     * Get word at the current cursor position.
     */
    public String getCurrentWord();

    /**
     * I wish that would be possible with XEmacs. At least with
     * NTEmacs it's possible with a trick.
     */
    public void toFrontAndFocus();
    
    public void editMethod(String sJavaClassFileFullName_,
                           String sMethod_);
    
    public boolean editMethod(String sFullMethod_);

    public void saveCurrentFile();

    public String getCurrentFileName();

    public void setColumnWidth(int columns_);
    
    /**
     * Editor specific commands. For example for Emacs this
     * will invoke gnudoit. Whoever uses this should first 
     * detect with instanceof or so the specific Editor so
     * he knows what he is doing.
     */
    public String system(String sCommand_);
}
