/*
 * This file is *NOT* part of GNU Emacs.
 *
 * This code, the source, and makefile are released under GNU GPL.
 *
 * 1.1 - now accepts window handle as decimal string
 */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int main(int c, char **a)
{
	LPSTR msgs, wps, lps;
	HWND hWndEmacs;
	int i,debugging;
	
	msgs = wps = lps = NULL;
	hWndEmacs = NULL;
	debugging = 0;
	
	for (i=1; i<c; i++)
	{
		if (stricmp(a[i],"/d")==0)
			debugging = 1;
		else if (strnicmp(a[i],"hwnd:",5)==0)
			hWndEmacs = (HWND) atol(&a[i][5]);
		else if (stricmp(a[i],"show")==0)
		{
			msgs = a[i];
			wps = a[i+1];
		}
		else if (strnicmp(a[i],"wm_",3)==0)
		{
			msgs = a[i];
			wps = a[i+1];
			if (i+2 <= c) lps = a[i+2];
		}
	}

	if ( (msgs==NULL) || (wps==NULL) )
	{
		printf("EMWINMSG: not enough args specified ([hwnd:n] show {arg})\n");
/*		printf("EMWINMSG: not enough args specified ([hwnd:n] show {arg} | WM_? {wParam [lParam]})\n"); */
		return 1;
	}

	/* find the emacs window */
	if (hWndEmacs==NULL)
	{
		if ((hWndEmacs = FindWindow("Emacs", NULL))==NULL)
		{
			printf("EMWINMSG: can't find emacs window\n");
			return 2;
		}
	}

	if (debugging)
	{
		printf("EMWINMSG: debug info\n"
			   "hWndEmacs = %d\n"
			   "WPARAMstr = %s\n"
			   "LPARAMstr = %s\n"
			   , (int)hWndEmacs
			   , wps
			   , lps
			);
		return 0;
	}

	/* parse the command */
	if (stricmp(msgs,"show")==0)
	{
		int sw;

		if (wps==NULL)
			wps = "normal";
		
		if (stricmp(wps,"hide")==0)					sw = SW_HIDE;
		else if (strnicmp(wps,"max",3)==0)			sw = SW_MAXIMIZE;
		else if (strnicmp(wps,"min",3)==0)			sw = SW_MINIMIZE;
		else if (stricmp(wps,"restore")==0)			sw = SW_RESTORE;
		else if (stricmp(wps,"show")==0)			sw = SW_SHOW;
		else if (stricmp(wps,"showdefault")==0)		sw = SW_SHOWDEFAULT;
		else if (stricmp(wps,"showmaximized")==0)	sw = SW_SHOWMAXIMIZED;
		else if (stricmp(wps,"showminimized")==0)	sw = SW_SHOWMINIMIZED;
		else if (stricmp(wps,"showminnoactive")==0)	sw = SW_SHOWMINNOACTIVE;
		else if (stricmp(wps,"showna")==0)			sw = SW_SHOWNA;
		else if (stricmp(wps,"shownoactivate")==0)	sw = SW_SHOWNOACTIVATE;
		else /*if (stricmp(wps,"shownormal")==0)*/	sw = SW_SHOWNORMAL;

		if (sw != SW_RESTORE)
			ShowWindowAsync( hWndEmacs, SW_RESTORE );

		ShowWindowAsync( hWndEmacs, sw );
	}
	else /* generic WM_? handling */
	{
	}

	/* all done */
	return 0;
}
